/*
  Project 2:   PC-based temperature and humidity logger
  Description: The DHT11 sensor is used to measure the ambient 
               temperature and relative humidity. The measured
               values are displayed on a PC and logged into a ASCII
               file through an application written using Processing.
  Board: chipKIT UNO32
 */
#include "dht11.h"
 
dht11 DHT11;

#define VCCPIN      7
#define DHT11PIN    6
#define GNDPIN      4


void setup()   
{
  Serial.begin(9600);
  pinMode(VCCPIN, OUTPUT);
  pinMode(GNDPIN, OUTPUT);
  digitalWrite(VCCPIN, HIGH);
  digitalWrite(GNDPIN, LOW);
}/*--(end setup )---*/

void loop()  
{
  int chk = DHT11.read(DHT11PIN);
  Serial.write(DHT11.humidity);
  Serial.write(DHT11.temperature);
  delay(2000);
}


